;0x000000832646e172
;
;  ALU_ASM.MZF
;  2018/01/31
;
_CR:            equ     0x0d
;
_a:     EQU     0A1H
_b:     EQU     09AH
_c:     EQU     09FH
_d:     EQU     09CH
_e:     EQU     092H
_f:     EQU     0AAH
_g:     EQU     097H
_h:     EQU     098H
_i:     EQU     0A6H
_j:     EQU     0AFH
_k:     EQU     0A9H
_l:     EQU     0B8H
_m:     EQU     0B3H
_n:     EQU     0B0H
_o:     EQU     0B7H
_p:     EQU     09EH
_q:     EQU     0A0H
_r:     EQU     09DH
_s:     EQU     0A4H
_t:     EQU     096H
_u:     EQU     0A5H
_v:     EQU     0ABH
_w:     EQU     0A3H
_x:     EQU     09BH
_y:     EQU     0BDH
_z:     EQU     0A2H
;_:     EQU     0H

;
aMSG:          equ      0015h        ; retezec na CRT
aqDPCT:        equ	0ddch        ; Provedeni ridicich znaku C0 - CF na CRT


ALU_DATA:       equ     26h
ALU_CMD:        equ     ALU_DATA+1

ALU_BUSY:       equ     80h
ALU_NEGATIVE:   equ     40h
ALU_ZERO:       equ     20h
ALU_UNDERFLOW:  equ     04h
ALU_OVERFLOW:   equ     02h
ALU_CARRY:      equ     01h

SMUL:           equ     03h
SQRT:           equ     10h
LOG:            equ     18h
LN:             equ     19h
EXP:            equ     1ah
PWR:            equ     1bh
PI:             equ     2ah

; MZF header
	org     START-0x80
;
	db	1                   ; OBJ file
	db	'ALU-ASM.MZF'
	db	_CR, _CR, _CR, _CR, _CR, _CR
	dw	PRGEND-START
	dw	START
	dw	START
        ds      104, 0
;
        org     2000h
;
START:
                ld      a, SQRT
                push    bc
                ld      hl, FP_10
                call    PUSHFP
                call    CMDFP
                ld      hl, DATA1
                call    POPFP

                ld      a, SMUL
                ld      hl, FP_10
                call    PUSHFP
                ld      hl, FP_PI
                call    PUSHFP
                call    CMDFP
                ld      hl, DATA2
                call    POPFP

                ld      a, SMUL
                ld      hl, FP_10
                ld      de, FP_PI
                call    PATH_AB

                pop     bc
                jp      0e804h                      ; go monitor
;
;
PATCH_SQR:      ld      a, SQRT
PATH_A:         push    bc
                call    PUSHFP
                call    CMDFP
                call    POPFP
                pop     bc
                ret
;
CMDFP:          out     (ALU_CMD), a

CMD_W:          in      a, (ALU_CMD)
                rl      a
                jr      c, CMD_W

                ret
;
PUSHFP:         push    hl
                ld      bc, 5*256+ALU_DATA
                otir
                pop     hl
                ret
;
POPFP:          push    hl
                ld      bc, 5*256+ALU_DATA
                inir
                pop     hl
                ret
;
FP_PI:          db      82h, 49h, 0fh, 0dah, 0a2h       ; 3.1415926
FP_10:          db      84h, 20h, 00h, 00h, 00h         ; 10

DATA1:          ds      5
DATA2:          ds      5
;DATA3:          ds      5

BUSY_CNT:       db      1
;
        org     57d0h           ; 5850h
;
; (HL) = arg
; A = operation
PATH_A1:        push    bc
                push    hl

                push    hl
PATH0:          ld      bc, 5*256+ALU_DATA
                otir

                out     (ALU_CMD), a

CMD_W1:         in      a, (ALU_CMD)
                rl      a
                jr      c, CMD_W1

                ld      b, 5
                pop     hl
                inir

                pop     hl
                pop     bc
                ret
;
;               PUSHFP (HL); PUSHFP (DE); MATH_OP; POPFP (HL)
; (DE) = argA
; (HL) = argB
; A = operation
PATH_AB:        push    bc
                push    hl

                push    hl
                push    de
                ld      bc, 5*256+ALU_DATA
                otir
                pop     hl

                jr      PATH0
;
PRGEND:
	end
